"use strict";
var base_http_service_1 = require('./../base-http.service');
var jwt_auth_helper_1 = require('./jwt-auth-helper');
var jwt_token_url_service_1 = require('./jwt-token-url.service');
var core_1 = require('@angular/core');
var http_1 = require('@angular/http');
var angular2_jwt_1 = require('angular2-jwt');
var Rx_1 = require('rxjs/Rx');
var JwtAuthConfiguration = (function () {
    function JwtAuthConfiguration(http, baseHttp, tokenUrl, adjJWtHelper) {
        this.http = http;
        this.baseHttp = baseHttp;
        this.tokenUrl = tokenUrl;
        this.adjJWtHelper = adjJWtHelper;
        this.url = this.tokenUrl.getJWTServletUrl();
    }
    JwtAuthConfiguration.prototype.makeAuthHttpReady = function (authHttpSource) {
        var jwtToken = localStorage.getItem('id_token');
        if (jwtToken)
            this.logDelta(jwtToken);
        if (this.tokenNeedsToBeRefreshed(jwtToken)) {
            this.refreshToken(jwtToken, authHttpSource);
        }
        else {
            this.createAuthHttp(jwtToken, authHttpSource);
        }
    };
    ;
    JwtAuthConfiguration.prototype.logDelta = function (token) {
        console.log("Delta: " + (new Date().valueOf() - this.adjJWtHelper.getTokenExpirationDate(token) / 1000));
    };
    JwtAuthConfiguration.prototype.tokenNeedsToBeRefreshed = function (token) {
        return token == null || token == undefined || this.adjJWtHelper.isTokenExpired(token, 60);
    };
    JwtAuthConfiguration.prototype.refreshToken = function (token, authHttpSource) {
        var _this = this;
        if (token)
            this.logToken(token);
        this.getObservableForToken().subscribe(function (response) { return _this.createAuthHttp(response, authHttpSource); });
        return token;
    };
    JwtAuthConfiguration.prototype.getObservableForToken = function () {
        var authTokenSource = new Rx_1.Subject();
        var authTokenSource$ = authTokenSource.asObservable();
        this.baseHttp.invokeWithUrl(this.url, null).subscribe(function (response) { return JwtAuthConfiguration.setToken(response, authTokenSource); }, function (error) { return console.error("Error :" + JSON.stringify(error)); }, function () { return console.log(" getObservableForToken is Completed !!!"); });
        return authTokenSource$;
    };
    ;
    JwtAuthConfiguration.setToken = function (response, authTokenSource) {
        var token = response._body;
        localStorage.setItem('id_token', token);
        authTokenSource.next(token);
        authTokenSource.complete();
    };
    JwtAuthConfiguration.prototype.logToken = function (token) {
        console.log("Now:     " + new Date().valueOf());
        console.log("Expires: " + this.adjJWtHelper.getTokenExpirationDate(token));
    };
    JwtAuthConfiguration.prototype.createAuthHttp = function (token, authHttpSource) {
        var authHttp = this.getNewAuthHttp(token);
        authHttpSource.next(authHttp);
        authHttpSource.complete();
    };
    JwtAuthConfiguration.prototype.getNewAuthHttp = function (token) {
        return new angular2_jwt_1.AuthHttp(new angular2_jwt_1.AuthConfig({
            noJwtError: true,
            globalHeaders: [{ 'Accept': 'application/json' }],
            tokenGetter: (function () { return token; }),
        }), this.http);
    };
    JwtAuthConfiguration = __decorate([
        core_1.Injectable(), 
        __metadata('design:paramtypes', [http_1.Http, base_http_service_1.BaseHttpService, jwt_token_url_service_1.JwtTokenUrlService, jwt_auth_helper_1.JwtAuthHelper])
    ], JwtAuthConfiguration);
    return JwtAuthConfiguration;
}());
exports.JwtAuthConfiguration = JwtAuthConfiguration;
//# sourceMappingURL=jwt-auth-configuration.js.map