"use strict";
var ng2_redux_1 = require('ng2-redux');
var core_1 = require('@angular/core');
var object_utils_1 = require('./../utils/object-utils');
var LocalStorageService = (function () {
    function LocalStorageService(ngZone, ngRedux) {
        this.ngZone = ngZone;
        this.ngRedux = ngRedux;
        this.storeKey = 'NO_KEY_SPECIFIED';
        LocalStorageService.INSTANCE = this;
        this.smartTableState = this.ngRedux.getState();
    }
    LocalStorageService.prototype.updateKey = function (key) {
        if (object_utils_1.ObjectUtils.isNotNullAndUndefined(key)) {
            this.storeKey = key;
        }
    };
    LocalStorageService.prototype.select = function (selector, comparator, returnProperty) {
        var _this = this;
        if (typeof selector === 'string' ||
            typeof selector === 'number' ||
            typeof selector === 'symbol') {
            return this.smartTableState[this.smartTableState];
        }
        else if (Array.isArray(selector) && this.storeKey) {
            var storeData = object_utils_1.ObjectUtils.getIn(this.smartTableState, selector);
            if (Array.isArray(storeData)) {
                var result = storeData.filter(function (item) { return item.tableName === _this.storeKey; });
                if (returnProperty) {
                    if (Array.isArray(result) && result[0]) {
                        return result[0][returnProperty];
                    }
                    else {
                        return result[returnProperty];
                    }
                }
                return result;
            }
        }
        return this.smartTableState;
    };
    LocalStorageService = __decorate([
        core_1.Injectable(), 
        __metadata('design:paramtypes', [core_1.NgZone, ng2_redux_1.NgRedux])
    ], LocalStorageService);
    return LocalStorageService;
}());
exports.LocalStorageService = LocalStorageService;
//# sourceMappingURL=local-storage.service.js.map