"use strict";
var object_utils_1 = require('./../utils/object-utils');
var template_loader_service_1 = require('./template-loader.service');
var configuration_service_1 = require('./configuration/configuration.service');
var base_http_service_1 = require('./base-http.service');
var core_1 = require('@angular/core');
var Rx_1 = require('rxjs/Rx');
var _ = require('underscore');
var SmartTableColumnService = (function () {
    function SmartTableColumnService(baseHttp, configuration, templateLoaderService) {
        this.baseHttp = baseHttp;
        this.configuration = configuration;
        this.templateLoaderService = templateLoaderService;
    }
    SmartTableColumnService.prototype.getData = function (jsonFileName) {
        var jsonUrl = this.configuration.getJsonUrl(jsonFileName);
        return this.baseHttp.invoke(jsonUrl);
    };
    SmartTableColumnService.prototype.getColumns = function (jsonFileName) {
        var _this = this;
        var jsonUrl = this.configuration.getJsonUrl(jsonFileName);
        var httpColumnSource = new Rx_1.AsyncSubject();
        var httpColumnSource$ = httpColumnSource.asObservable();
        var columns = {};
        this.baseHttp.invoke(jsonUrl).subscribe(function (resp) {
            _this.mapColumns(resp, columns, httpColumnSource);
        }, function (error) {
            _this.handleError(error);
        });
        return httpColumnSource$;
    };
    SmartTableColumnService.prototype.mapColumns = function (resp, columns, httpColumnSource) {
        var _this = this;
        var definitionMap = JSON.parse(resp._body);
        var uniqueTemplateMap = new Object();
        uniqueTemplateMap['viewTemplate'] = new Array();
        uniqueTemplateMap['EditTemplate'] = new Array();
        uniqueTemplateMap['searchTemplate'] = new Array();
        uniqueTemplateMap['searchDescriptionTemplate'] = new Array();
        var templateUrls = new Object();
        definitionMap.forEach(function (definition) {
            if (definition['attr']) {
                columns[definition['attr']] = definition;
                columns[definition['attr']]['id'] = definition['attr'];
                var column = columns[definition['attr']];
                _this.updateUniqueTemplateMap(definition.viewTemplate, 'viewTemplate', uniqueTemplateMap);
                _this.updateUniqueTemplateMap(definition.editTemplate, 'editTemplate', uniqueTemplateMap);
                _this.updateUniqueTemplateMap(definition.searchTemplate, 'searchTemplate', uniqueTemplateMap);
                _this.updateUniqueTemplateMap(definition.searchDescriptionTemplate, 'searchDescriptionTemplate', uniqueTemplateMap);
            }
        });
        httpColumnSource.next(columns);
        this.templateLoaderService.loadTemplates(columns, uniqueTemplateMap, httpColumnSource);
    };
    SmartTableColumnService.prototype.updateUniqueTemplateMap = function (url, type, uniqueTemplateMap) {
        if (object_utils_1.ObjectUtils.isNotNullAndUndefined(url) && this.notContains(uniqueTemplateMap[type], url)) {
            uniqueTemplateMap[type].push({ key: url, value: '' });
        }
    };
    SmartTableColumnService.prototype.notContains = function (templateUrls, url) {
        var returnValue = true;
        templateUrls.forEach(function (template) {
            if (template.key === url) {
                returnValue = false;
                return false;
            }
        });
        return returnValue;
    };
    SmartTableColumnService.prototype.handleError = function (error) {
        console.error(error);
        return Rx_1.Observable.throw(error || 'Server error');
    };
    SmartTableColumnService.sentencify = function (str) {
        return str && str.replace(/([a-z])([A-Z])/g, "$1 $2");
    };
    SmartTableColumnService = __decorate([
        core_1.Injectable(), 
        __metadata('design:paramtypes', [base_http_service_1.BaseHttpService, configuration_service_1.ConfigurationService, template_loader_service_1.TemplateLoaderService])
    ], SmartTableColumnService);
    return SmartTableColumnService;
}());
exports.SmartTableColumnService = SmartTableColumnService;
//# sourceMappingURL=smart-table-column.service.js.map