"use strict";
var object_utils_1 = require('./../../utils/object-utils');
var constants_1 = require('./../../utils/constants');
exports.INITIAL_PAGER_STATE = [{
        tableName: 'INITIAL',
        pager: {
            page: 1,
            perPage: 50
        }
    }];
exports.INITIAL_SORT_STATE = [{
        tableName: 'INITIAL',
        sorts: [{
                field: 'temp',
                direction: 'asc',
                compare: null
            }]
    }];
exports.INITIAL_ROW_SELECTION_STATE = [{
        tableName: 'INITIAL',
        rows: new Array()
    }];
exports.INITIAL_COLUMN_SELECTION_STATE = [{
        tableName: 'INITIAL',
        columns: new Array()
    }];
//Sort rootReducer
function smartTableSortReducer(state, action) {
    if (state === void 0) { state = exports.INITIAL_SORT_STATE; }
    switch (action.type) {
        case constants_1.Constants.ON_COLUMN_SORT:
            var matchedItem = object_utils_1.ObjectUtils.contains(state, action.payload, 'tableName');
            if (matchedItem) {
                object_utils_1.ObjectUtils.crudRightToLeft(matchedItem.sorts, action.payload.sorts);
            }
            else {
                state.push(action.payload);
            }
            return state;
        default:
            return state;
    }
}
exports.smartTableSortReducer = smartTableSortReducer;
//Pager reducer
function smartTablePagerReducer(state, action) {
    if (state === void 0) { state = exports.INITIAL_PAGER_STATE; }
    switch (action.type) {
        case constants_1.Constants.ON_PAGINATED:
            var matchedItem = object_utils_1.ObjectUtils.contains(state, action.payload, 'tableName');
            if (matchedItem) {
                Object.assign(matchedItem.pager, action.payload.pager);
            }
            else {
                state.push(action.payload);
            }
            return state;
        default:
            return state;
    }
}
exports.smartTablePagerReducer = smartTablePagerReducer;
//Row selection Reducer
function smartTableRowSelectionReducer(state, action) {
    if (state === void 0) { state = exports.INITIAL_ROW_SELECTION_STATE; }
    switch (action.type) {
        case constants_1.Constants.ON_ROW_SELECTION_CHANGE: {
            var matchedItem = object_utils_1.ObjectUtils.contains(state, action.payload, 'tableName');
            if (matchedItem) {
                object_utils_1.ObjectUtils.crudRightToLeft(matchedItem.rows, action.payload.rows);
            }
            else {
                state.push(action.payload);
            }
            return state;
        }
        default:
            return state;
    }
}
exports.smartTableRowSelectionReducer = smartTableRowSelectionReducer;
//Column selection Reducer
function smartTableColumnSelectionReducer(state, action) {
    if (state === void 0) { state = exports.INITIAL_COLUMN_SELECTION_STATE; }
    switch (action.type) {
        case constants_1.Constants.ON_COLUMN_SELECTION_CHANGE: {
            var matchedItem = object_utils_1.ObjectUtils.contains(state, action.payload, 'tableName');
            if (matchedItem) {
                object_utils_1.ObjectUtils.crudRightToLeft(matchedItem.columns, action.payload.columns);
            }
            else {
                state.push(action.payload);
            }
            return state;
        }
        default:
            return state;
    }
}
exports.smartTableColumnSelectionReducer = smartTableColumnSelectionReducer;
//# sourceMappingURL=smart-table.reducers.js.map