"use strict";
var _ = require('underscore');
var core_1 = require('@angular/core');
var MultiJoiner = (function () {
    function MultiJoiner() {
    }
    MultiJoiner.prototype.transform = function (elem, args) {
        if (!elem)
            return null;
        var pairs = [
            [elem.statusCategoryCode1, elem.statusCode1],
            [elem.statusCategoryCode2, elem.statusCode2],
            [elem.statusCategoryCode3, elem.statusCode3]
        ];
        // _.partial(_.every, _, angular.identity);
        var hasData = function (pair) {
            return _.some(pair);
        };
        var joinpair = function (pair) {
            return _.filter(pair).join('-');
        };
        var codes = _.chain(pairs)
            .filter(hasData)
            .map(joinpair)
            .join('/')
            .value();
        return [codes, elem.freeFormMessageText].join(' - ');
    };
    MultiJoiner = __decorate([
        core_1.Pipe({ name: 'MultiJoiner' }), 
        __metadata('design:paramtypes', [])
    ], MultiJoiner);
    return MultiJoiner;
}());
exports.MultiJoiner = MultiJoiner;
//# sourceMappingURL=multi-joiner.pipe.js.map