"use strict";
var ObjectUtils = (function () {
    function ObjectUtils() {
    }
    ObjectUtils.getArrayOfObjects = function (data) {
        var listOfObjects = new Array();
        data.forEach(function (item) {
            var obj = new Object();
            obj['id'] = item;
            obj['label'] = item;
            obj['value'] = item;
            listOfObjects.push(obj);
        });
        return listOfObjects;
    };
    ObjectUtils.contains = function (list, inputItem, checker) {
        var matchedItem;
        if (ObjectUtils.isNotNullAndUndefined(list) && ObjectUtils.isNotNullAndUndefined(inputItem)) {
            list.forEach(function (item) {
                if (item[checker] === inputItem[checker])
                    matchedItem = item;
                return;
            });
        }
        return matchedItem;
    };
    ObjectUtils.containsItem = function (obj, inputItem) {
        var isEqual = false;
        if (ObjectUtils.isNotNullAndUndefined(obj) && ObjectUtils.isNotNullAndUndefined(inputItem)) {
            Object.keys(obj).forEach(function (item) {
                if (item === inputItem)
                    isEqual = true;
                return;
            });
        }
        return isEqual;
    };
    ObjectUtils.getIn = function (object, pathElems) {
        if (!object) {
            return object;
        }
        // If this is an ImmutableJS structure, use existing getIn function
        if (typeof object.getIn === 'function') {
            return object.getIn(pathElems);
        }
        var firstElem = pathElems[0], restElems = pathElems.slice(1);
        if (undefined === object[firstElem]) {
            return undefined;
        }
        if (restElems.length === 0) {
            return object[firstElem];
        }
        return ObjectUtils.getIn(object[firstElem], restElems);
    };
    ObjectUtils.isNullOrUndefined = function (value) {
        return value === null || value === undefined;
    };
    ObjectUtils.isNotNullAndUndefined = function (value) {
        return value != null && value != undefined;
    };
    ObjectUtils.isEmpty = function (value) {
        return value === null || value === undefined || (Object.keys(value.trim()).length === 0);
    };
    ObjectUtils.isEmptyArray = function (value) {
        return value === null || value === undefined || (Object.keys(value).length === 0);
    };
    ObjectUtils.crudRightToLeft = function (leftArray, rightArray) {
        var finalArray = new Array();
        rightArray.forEach(function (item) {
            var matchedItem = ObjectUtils.contains(leftArray, item, 'id');
            if (ObjectUtils.isNotNullAndUndefined(matchedItem)) {
                Object.keys(item).forEach(function (itemKey) {
                    matchedItem[itemKey] = item[itemKey];
                });
            }
            else {
                leftArray.push(item);
            }
        });
        return leftArray;
    };
    return ObjectUtils;
}());
exports.ObjectUtils = ObjectUtils;
//# sourceMappingURL=object-utils.js.map