import 'normalize.css';
import 'angular-loading-bar/build/loading-bar.min.css';
import angular from 'angular';
import uiRouter from 'angular-ui-router';
import ngAnimate from 'angular-animate';
import ngStorage from 'angular-storage';
import ngMessages from 'angular-messages';
import ngMdIcons from 'angular-material-icons';
import ngMaterial from 'angular-material';
import satelizer from 'satellizer';
import angularInlineEdit from './../build/assets/ng-inline-edit/index';
import AuthInterceptor from './shared/auth.interceptor';
import angularLoadingBar from 'angular-loading-bar';
import run from './run';
import {appDirective} from './app.directive';
import toastr from 'angular-toastr';
import {directivesModule} from './directives/directives.module';
import {shared} from './shared/shared';
import {home} from './components/home/home';
import {admin} from './components/admin/admin';
import {header} from './components/header/header.module';
import {login} from './views/login/login';
import {user} from './views/user/user';
import {infiniteScroll} from './directives/infinite-scroll/infinite-scroll';
import {company} from './views/company/company';
import {haspermission} from './directives/has-permission/has.permission.directive';
import {sideMenuDirective} from "./components/side-menu/side-menu.directive";
import {menuToggle} from './directives/menu-toggle/menu-toggle.directive';
import {menuLink} from './directives/menu-link/menu-link.directive';

angular.module('exc', [
	uiRouter,
	ngAnimate,
	ngStorage,
	ngMessages,
	ngMdIcons,
	ngMaterial,
	satelizer,
	angularLoadingBar,
	angularInlineEdit,
	toastr,
	shared.name,
	header.name,
	directivesModule.name,
	home.name,
	admin.name,
	login.name,
	user.name,
	company.name
])
	.factory('AuthInterceptor', AuthInterceptor)
	.config(($httpProvider, toastrConfig,$mdIconProvider) => {
		angular.extend(toastrConfig, {
			autoDismiss          : true,
			containerId          : 'toast-container',
			maxOpened            : 5,
			newestOnTop          : true,
			positionClass        : 'toast-top-right',
			preventDuplicates    : false,
			preventOpenDuplicates: false,
			target               : 'body',
			templates            : {
				toast: 'app/directives/toastr/toast.html'
			}
		});

		$httpProvider.interceptors.push('AuthInterceptor');
		$mdIconProvider.icon("menu", "./build/assets/img/svg/menu.svg", 24);
	})
	.filter('nospace', function () {
		return function (value) {
			return (!value) ? '' : value.replace(/ /g, '');
		};
	})
	//replace uppercase to regular case
	.filter('humanizeDoc', function () {
		return function (doc) {
			if (!doc) return;
			if (doc.type === 'directive') {
				return doc.name.replace(/([A-Z])/g, function ($1) {
					return '-' + $1.toLowerCase();
				});
			}

			return doc.label || doc.name;
		};
	})
	.directive('exc', appDirective)
	.directive('haspermission', haspermission)
	.directive('sideMenu', sideMenuDirective)
	.directive('menuToggle', menuToggle)
	.directive('menuLink', menuLink)
	.directive('infiniteScroll', infiniteScroll)
	.run(run);
