'use strict';
class CompanyDetails {

	constructor($scope, helperService, $state, $stateParams, companyService) {
		this.user           = JSON.parse(localStorage.getItem('user'));
		this.helperService  = helperService;
		this.$scope         = $scope;
		this.$state         = $state;
		this.$stateParams   = $stateParams;
		this.companyService = companyService;
		this.init();
		this.watchIt();
	}

	init() {
		this.contact = this.helperService.getTransferredObject(this.$stateParams.id)
		if (_.size(this.company) == 0) {
			this.companyService.getCompany(this.$stateParams.id).then(data => {
				this.company = data;
			});
		}
	}

	whatToWatch = () => {
		return this.company;
	}

	watcher = (newData, oldData) => {
		if (!_.isMatch(newData, oldData)) {
			if (!this.triggeredUpdate) {
				this.triggeredUpdate = true;
				this.companyService.editCompanyInline(newData).then(this.companyServiceResponse);
			}
		}
	}

	watchIt() {
		this.$scope.$watchCollection(this.whatToWatch, this.watcher);
	}
}
CompanyDetails.$inject = ['$scope','helperService', '$state', '$stateParams', 'companyService'];

export {CompanyDetails};
