class CompanyController {
	constructor($scope, $state, companyService, messageService, helperService) {
		this.user             = JSON.parse(localStorage.getItem('user'));
		this.company          = this.user.company;
		this.$scope           = $scope;
		this.$state           = $state;
		this.companyService   = companyService;
		this.messageService   = messageService;
		this.helperService    = helperService;
		this.triggeredUpdate  = false;
		this.limit            = 5;
		this.lazyLoadFinished = false;
		this.offset           = 0;
		this.companies        = [];
		this.getCompanies();
		this.watchIt();
	}

	getCompanies() {
		this.lazyLoadFinished = false;
		var data              = {
			"order" : {
				"id": "asc"
			},
			"limit" : this.limit,
			"offset": this.offset
		};
		this.companyService.getCompanies(data).then((data) => {
			if (_.size(data) === 0) {
				this.lazyLoadFinished = true;
				return;
			}
			_.each(data, (item, key) => {
				this.companies.push(item);
			});

			this.offset = this.limit;
			this.limit  = this.limit + 5;
		});
	}


	companyServiceResponse = (data) => {
		if (data === false) {
			this.messageService.errorMsg("Company is not edited");
			this.triggeredUpdate = false;
			return false;
		}

		this.messageService.successMsg("Company is edited");
		this.userService.setUser(data);
		this.triggeredUpdate = false;
	}

	whatToWatch = () => {
		return this.company;
	}

	watcher = (newData, oldData) => {
		if (!_.isMatch(newData, oldData)) {
			if (!this.triggeredUpdate) {
				this.triggeredUpdate = true;
				this.companyService.editCompanyInline(newData).then(this.companyServiceResponse);
			}
		}
	}

	watchIt() {
		this.$scope.$watchCollection(this.whatToWatch, this.watcher);
	}

	viewDetails(company) {
		this.helperService.setTransferredObject(company.id, company);
		this.$state.go('company-details', {id: company.id});
	}
}

CompanyController.$inject = ['$scope', '$state', 'companyService', 'messageService', 'helperService'];
export {CompanyController};
