'use strict';

class UserInfoController {

	constructor($scope, AuthenticationService, $state, userService, $rootScope) {
		this.$rootScope            = $rootScope;
		this.$scope                = $scope;
		this.$state                = $state;
		this.user                  = {};
		this.userService           = userService;
		this.AuthenticationService = AuthenticationService;
		this.title                 = "PLATFORM";
		this.initDirective();
		this.$scope.$watch(this.whatToWatch, this.watcher);
	}

	watcher = (newVal, oldVal) => {
		if (oldVal !== newVal) {
			this.user = JSON.parse(localStorage.getItem('user'));
			this.userService.setUser(this.user);
			this.$scope.$evalAsync();
		}
	}

	whatToWatch = () => {
		return localStorage.getItem('user');
	}

	initDirective() {
		return this.userService.getUser().then((data) => {
			this.user = data;
		});
	}


	logout() {
		this.AuthenticationService.Logout();
		this.$state.go('login', {location: true});
	};

}

UserInfoController.$inject = ['$scope', 'AuthenticationService', '$state', 'userService', '$rootScope'];

export {UserInfoController};
