import angular from 'angular';

let config = ($httpProvider, toastrConfig) => {
	angular.extend(toastrConfig, {
		autoDismiss          : true,
		containerId          : 'toast-container',
		maxOpened            : 5,
		newestOnTop          : true,
		positionClass        : 'toast-top-right',
		preventDuplicates    : false,
		preventOpenDuplicates: false,
		target               : 'body',
		templates            : {
			toast: 'app/directives/toastr/toast.html'
		}
	});
	$httpProvider.interceptors.push('AuthInterceptor');
}

config.$inject = ['$httpProvider', 'toastrConfig'];

export {config};
