class CompanyDialogController {

	constructor($scope, companyService) {

		this.$scope        = $scope;
		this.companyService = companyService;
	}

	createCompany() {
		this.$scope.ctrl.stepOne   = false;
		this.$scope.ctrl.stepTwo   = true;
		this.$scope.ctrl.stepThree = false;
		this.$scope.ctrl.stepError = false;
		this.$scope.ctrl.error     = 'Error ocured...please call batman';
		let data                   = this.setUpCompanyData();
		this.companyService.createCompany(data).then(this.successResp, this.errorResp);
	};

	setUpCompanyData() {
		var data          = {};
		data.countries   = this.$scope.ctrl.countries;
		data.companyName    = this.$scope.ctrl.companyName;
		data.legalform     = this.$scope.ctrl.legalform;
		data.type         = "company_create";

		return data;
	}

	successResp(data) {
		if (data.data.type !== "success") {
			this.$scope.ctrl.error     = data.data.message;
			this.$scope.ctrl.stepTwo   = false;
			this.$scope.ctrl.stepError = true;
			return;
		}
		this.$scope.ctrl.stepTwo   = false;
		this.$scope.ctrl.stepThree = true;
	}

	displayErrors() {
		this.$scope.ctrl.stepTwo   = false;
		this.$scope.ctrl.stepError = true;
	}

	errorResp(error) {
		if (!_.isUndefined(error.data.error)) {
			this.$scope.ctrl.error = error.data.error.exception[0].message;
			this.displayErrors();
			return;
		}
		this.$scope.ctrl.error = error.data.message;
		this.displayErrors();
	}


	createAnotherCompany() {
		this.resetVars();
		this.$scope.ctrl.stepThree = false;
		this.$scope.ctrl.stepError = false;
		this.$scope.ctrl.stepOne   = true;
	};

	resetVars() {
		this.$scope.ctrl.company = '';
		this.$scope.ctrl.companyName      = '';
		this.$scope.ctrl.legalform       = '';
		this.$scope.ctrl.error          = 'Error ocured...please call batman';
	}
}

CompanyDialogController.$inject = ['$scope', 'companyService'];

export {CompanyDialogController};

