'use strict';
const createCompany = ($mdDialog, $timeout, companyService, countriesService) => {
	function link(scope) {
		let alert;
		scope.showCompanyDialog = showCompanyDialog;
		scope.companyName       = '';
		scope.legalforms         = [{name:"test 1","code":1},{name:"test 2",code:2}];
		scope.countries         = countriesService.getCountries();

		function showCompanyDialog($event) {
			var parentEl = angular.element(document.querySelector('body'));
			alert        = $mdDialog.alert({
				parent          : parentEl,
				targetEvent     : $event,
				templateUrl     : 'app/directives/create-company/views/create-company-form.html',
				locals          : {
					countries  : scope.countries,
					legalforms  : scope.legalforms,
					companyName: scope.companyName,
					stepOne    : true,
					stepTwo    : false,
					stepThree  : false,
					stepError  : false,
					user       : scope.user,
					closeDialog: scope.closeDialog
				},
				bindToController: true,
				controllerAs    : 'ctrl',
				controller      : 'CompanyDialogController'
			});

			$mdDialog
				.show(alert)
				.finally(function () {
					alert = undefined;
				});
		}

		scope.closeDialog = function () {
			$mdDialog.hide();
		};

	}

	return {
		restrict    : 'E',
		templateUrl : 'app/directives/create-company/views/createCompany.html',
		scope       : {
			user: "="
		},
		link        : link,
		controllerAs: 'vm'
	}

}

createCompany.$inject = ['$mdDialog', '$timeout', 'companyService', 'countriesService'];

export {createCompany};


