'use strict';

const haspermission = ($timeout) => {
	return {
		restrict: 'A',
		link    : function (scope, elem, attr) {
			let role = attr.haspermission;

			function show(element) {
				element.removeClass('hide');
				element.addClass('show');
			}

			function hide(element) {
				element.removeClass('show');
				element.addClass('hide');
			}

			let checkUser = () => {
				if (role === 'ROLE_ANONIMOUS') return;
				let user = localStorage.getItem('user');
				if (!user || user === null) {
					hide(elem);
					return;
				}

				if (user !== null) {
					user = JSON.parse(user);
					if (user instanceof Object) {
						if (user.roles.indexOf(role) === -1) {
							hide(elem);
							return;
						}
					}
				}
				show(elem);
			}

			if (role) {
				checkUser();
			}

			scope.$on('event:auth-logout-succeed', function (data) {
				checkUser();
			});
			scope.$on('event:auth-login-complete', function (data) {
				checkUser();
			});

		}
	}
}

haspermission.$inject = ['$timeout'];

export {haspermission};

