class DialogController {

	constructor($scope, inviteService) {
		this.$scope        = $scope;
		this.inviteService = inviteService;
/*		this.$scope.ctrl.inviteColleague = this.inviteColleague();
		this.$scope.ctrl.inviteAnotherColleague = this.inviteAnotherColleague();
		this.$scope.ctrl.resetVars = this.resetVars();*/
	}

	inviteColleague() {
		this.$scope.ctrl.stepOne   = false;
		this.$scope.ctrl.stepTwo   = true;
		this.$scope.ctrl.stepThree = false;
		this.$scope.ctrl.stepError = false;
		this.$scope.ctrl.error     = 'Error ocured...please call batman';
		let data                   = this.setUpInviteData();
		this.inviteService.inviteColleague(data).then(this.successResp, this.errorResp);
	};

	setUpInviteData() {
		var data          = {};
		data.salutation   = this.$scope.ctrl.userSalutation;
		data.firstname    = this.$scope.ctrl.firstname;
		data.lastname     = this.$scope.ctrl.lastname;
		data.email        = this.$scope.ctrl.email;
		data.company      = {};
		data.company.id   = this.$scope.ctrl.user.company.id;
		data.company.name = this.$scope.ctrl.user.company.name;
		data.type         = "invite";

		return data;
	}

	successResp(data) {
		if (data.data.type !== "success") {
			this.$scope.ctrl.error     = data.data.message;
			this.$scope.ctrl.stepTwo   = false;
			this.$scope.ctrl.stepError = true;
			return;
		}
		this.$scope.ctrl.stepTwo   = false;
		this.$scope.ctrl.stepThree = true;
	}

	displayErrors() {
		this.$scope.ctrl.stepTwo   = false;
		this.$scope.ctrl.stepError = true;
	}

	errorResp(error) {
		if (!_.isUndefined(error.data.error)) {
			this.$scope.ctrl.error = error.data.error.exception[0].message;
			this.displayErrors();
			return;
		}
		this.$scope.ctrl.error = error.data.message;
		this.displayErrors();
	}


	inviteAnotherColleague() {
		this.resetVars();
		this.$scope.ctrl.stepThree = false;
		this.$scope.ctrl.stepError = false;
		this.$scope.ctrl.stepOne   = true;
	};

	resetVars() {
		this.$scope.ctrl.userSalutation = '';
		this.$scope.ctrl.firstname      = '';
		this.$scope.ctrl.lastname       = '';
		this.$scope.ctrl.email          = '';
		this.$scope.ctrl.error          = 'Error ocured...please call batman';
	}
}

DialogController.$inject = ['$scope', 'inviteService'];

export {DialogController};

