'use strict';
const invite = ($mdDialog, $timeout, inviteService, messageService) => {
	function link(scope) {
		let alert;
		scope.showDialog     = showDialog;
		scope.userSalutation = '';
		scope.firstname      = '';
		scope.lastname       = '';
		scope.email          = '';
		scope.salutations    = [{"name": 'Mrs'}, {"name": 'Mr'}, {"name": 'Dr'}];

		function showDialog($event) {
			var parentEl = angular.element(document.querySelector('body'));
			alert        = $mdDialog.alert({
				parent          : parentEl,
				targetEvent     : $event,
				templateUrl     : 'app/directives/invite/views/invite-form.html',
				locals          : {
					items                 : scope.salutations,
					userSalutation        : scope.userSalutation,
					firstname             : scope.firstname,
					lastname              : scope.lastname,
					stepOne               : true,
					stepTwo               : false,
					stepThree             : false,
					stepError             : false,
					email                 : scope.email,
					user                  : scope.user,
					closeDialog           : scope.closeDialog
				},
				bindToController: true,
				controllerAs    : 'ctrl',
				controller      : 'DialogController'
			});

			$mdDialog
				.show(alert)
				.finally(function () {
					alert = undefined;
				});
		}

		scope.closeDialog = function () {
			$mdDialog.hide();
		};

	}

	return {
		restrict        : 'E',
		templateUrl     : 'app/directives/invite/views/invite.html',
		scope           : {
			user: "="
		},
		link            : link,
		controllerAs:'vm'
	}

}

invite.$inject = ['$mdDialog', '$timeout', 'inviteService'];

export {invite};


