import template from './views/menu-toggle.html';

const menuToggle = ($timeout) => {
	return {
		scope  : {
			section: '='
		},
		require: "^sideMenu",
		template,
		link   : function (scope, element, attrs, sideMenuController) {
			var controller = sideMenuController;

			scope.isOpen = function () {
				return controller.isOpen(scope.section);
			};
			scope.toggle = function () {
				controller.toggleOpen(scope.section);
			};

			var parentNode = element[0].parentNode.parentNode.parentNode;
			if (parentNode.classList.contains('parent-list-item')) {
				var heading = parentNode.querySelector('h2');
				element[0].firstChild.setAttribute('aria-describedby', heading.id);
			}
		}
	}
}

menuToggle.$inject = ['$timeout'];

export {menuToggle};
