'use strict';

class AuthInterceptor {
	constructor($q, $window) {
		this.$q      = $q;
		this.$window = $window;
		this.loginPath = '/#/login';
	}

	request = (config) => {
		if (localStorage.getItem('token')) {
			config.headers.Authorization = 'Bearer ' + JSON.parse(localStorage.getItem('token'));
		} else {
			this.$window.location.href = this.loginPath;
		}

		return config || self.$q.when(config);
	}

	requestError = (rejection) => {
		return this.$q.reject(rejection);
	}

	response = (response) => {
		if (response.status === 401) {
			localStorage.removeItem('token');
			this.$window.location.href = this.loginPath;
		}

		return response || this.$q.when(response);
	}

	responseError = (rejection) => {
		if (rejection.status === 401) {
			localStorage.removeItem('token');
			localStorage.removeItem('user');
			this.$window.location.href = this.loginPath;
		}
		return this.$q.reject(rejection);
	}

	static factory = ($window, $q) => {
		return new AuthInterceptor($window, $q);
	}
}

AuthInterceptor.factory.$inject = ['$q', '$window'];

export default AuthInterceptor.factory;
