'use strict';

const AuthenticationService = ($http, $q, __env, REST, userService) => {

	const scope = angular.element(document).scope();
	const clearStorage = () => {
		localStorage.removeItem('user');
		localStorage.removeItem('token');
	}

	const Login = (email, password) => {
		var defer     = $q.defer();
		var cred      = {email: email, password: password};
		cred.password = sha512(cred.email + '' + cred.password);
		$http
			.post(__env.getEnvironment().apiUrl + REST.login, cred)
			.success(function (data, status, headers, config) {
				if (data.entity) {
					localStorage.setItem('token', JSON.stringify(data.token));
					userService.setUser(data.entity);
					scope.$broadcast('event:auth-login-complete', {data: data, status: status});
				}
				defer.resolve(true);

			})
			.error(function (data, status, headers, config) {
				clearStorage();
				scope.$broadcast('event:auth-login-failed', {data: data, status: status});
				defer.reject(false);
			});

		return defer.promise;
	}

	function Logout() {
		delete $http.defaults.headers.common.Authorization;
		clearStorage();
		var data = {
			message: "You are logged out!",
			user   : {}
		};

		scope.$broadcast('event:auth-logout-succeed', {data: data, status: 401});
	}

	return {Login, Logout};

}

AuthenticationService.$inject = ['$http', '$q', '__env', 'REST', 'userService'];

export {AuthenticationService};
