'use strict';

const companyService = ($q, $http, REST, __env, ROLE, helperService, $httpParamSerializer, $cacheFactory) => {
	var cache = $cacheFactory(companyService);

	const getCompanies = (data) => {
		let cacheKey = JSON.stringify(data);
		var promise = $q.defer();
		var service = __env.getEnvironment().apiUrl + REST.companies + '?' + $httpParamSerializer(data);

		let companyData = cache.get(cacheKey);
		if (companyData) {
			promise.resolve(companyData);
			return promise.promise;
		}

		$http({
			method: "get",
			url: service
		}).then(function (data) {
			cache.put(cacheKey, data.data);
			promise.resolve(data.data);
		}, function (error) {
			promise.reject(false);
		});

		return promise.promise;
	}

	const getCompany = (id) => {
		let promise  = $q.defer();
		let cacheKey = id;
		let url      = __env.getEnvironment().apiUrl + REST.companies + '/' + id

		let companyData = cache.get(cacheKey);
		if (companyData) {
			promise.resolve(companyData);
			return promise.promise;
		}

		$http({
			method: "get",
			url   : url
		}).then(function (data) {
			cache.put(cacheKey, data.data);
			promise.resolve(data.data);
		}, function (error) {
			promise.reject(false);
		});

		return promise.promise;
	}

	const editCompanyInline = (companydata) => {
		var promise = $q.defer();
		var service = __env.getEnvironment().apiUrl + REST.company_edit_inline;
		$http({
			method: "put",
			url: service + '/' + companydata.id,
			data: companydata
		}).then(function (data) {
			promise.resolve(data.data);
		}, function (error) {
			promise.reject(false);
		});

		return promise.promise;
	}


	const createCompany = (companydata) => {
		var promise = $q.defer();
		var service = __env.getEnvironment().apiUrl + REST.company_create;
		$http({
			method: "post",
			url: service,
			data: companydata
		}).then(function (data) {
			promise.resolve(data.data);
		}, function (error) {
			promise.reject(false);
		});

		return promise.promise;
	}

	return { editCompanyInline, getCompany, getCompanies, createCompany};
}

companyService.$inject = ['$q', '$http', 'REST', '__env', 'ROLE', 'helperService', '$httpParamSerializer', '$cacheFactory'];

export {companyService};
