'use strict';

/**
 * Service to handle events fired all over the app and to show toast messages to user
 */
const eventListenerService = ( messageService, $state) => {
	let $scope;

	const saveScope = (scope) => {
		$scope = scope;
	}

	const listen = ()=> {
		$scope.$on('event:auth-logout-succeed', logoutSucceed);
		$scope.$on('event:auth-logout-failed', logoutFailed);
		$scope.$on('event:auth-login-failed', loginFailed);
		$scope.$on('event:auth-login-complete', loginSuccess);
	}

	const logoutSucceed = (event, args) => {
		$state.go('login', {location: true});
		messageService.successMsg('You are logged out of the system', 'Success');
	}

	const logoutFailed = (event, args) => {
		messageService.errorMsg('Token not found, please log in!', 'Error');
	}

	const loginFailed = (event, args) => {
		messageService.errorMsg('Login failed! ' + args.data.message, 'Error');

	}

	const loginSuccess = (event, args) => {
		$state.go('home', {location: true});
		messageService.successMsg(args.data.message + ' , You are logged in!', 'Success');
	}

	return {saveScope,listen};
}

eventListenerService.$inject = ['messageService', '$state'];

export {eventListenerService};
