'use strict';

const helperService = ($q, $http, $cacheFactory) => {
	var cache = $cacheFactory('helper');

	const arrayIntersect = (array1, array2) => {
		var response = false;
		_.each(array1, function (item, key) {
			if (array2.indexOf(item) > -1) {
				response = true;
			}
		});
		return response;
	}

	const setTransferredObject = (cacheKey, objectData) => {
		return cache.put(cacheKey, objectData);
	}

	const getTransferredObject = (cacheKey) => {
		return cache.get(cacheKey);
	}

	return {
		arrayIntersect,
		setTransferredObject,
		getTransferredObject
	};
}

helperService.$inject = ['$q', '$http', '$cacheFactory'];

export {helperService};
