'use strict';

const menu = ($location) => {
	var sections = [];
	sections.push(
		{
			name : 'User',
			type : 'toggle',
			pages: [
				{
					name : 'Details',
					state: 'user',
					type : 'link',
					icon : 'face',
					role : 'ROLE_SUPER_ADMIN'
				},
				{
					name : 'Logout',
					state: 'login',
					type : 'link',
					icon : 'logout',
					role : 'ROLE_ANONIMOUS'
				}
			]
		},
		{
			name : 'Companies',
			type : 'toggle',
			pages: [
				{
					name : 'Company',
					type : 'link',
					state: 'company',
					icon : 'domain',
					role : 'ROLE_SUPER_ADMIN'
				}
			]
		},

		{
			name : 'Contacts',
			type : 'toggle',
			pages: [
				{
					name : 'Contact',
					type : 'link',
					state: 'user-contacts',
					icon : 'group',
					role : 'ROLE_SUPER_ADMIN'
				}
			]
		}
	);

	var self;
	return self = {
		sections: sections,

		toggleSelectSection: function (section) {
			self.openedSection = (self.openedSection === section ? null : section);
		},
		isSectionSelected  : function (section) {
			return self.openedSection === section;
		},

		selectPage: function (section, page) {
			page && page.url && $location.path(page.url);
			self.currentSection = section;
			self.currentPage    = page;
		}
	};

	function sortByHumanName(a, b) {
		return (a.humanName < b.humanName) ? -1 :
			(a.humanName > b.humanName) ? 1 : 0;
	}

}

export {menu};

