import {api} from './api';
import {ROLE} from './config/role.config';
import {REST} from './config/rest.routes.config';
import {posts} from './posts';
import angular from 'angular';
import {__env} from './env';
import {eventListenerService} from './event.listener.service';
import {messageService} from './message.service';
import {AuthenticationService} from './authentication.service';
import {userService} from './user.service';
import {helperService} from './helper.service';
import {menu} from './menu.service';
import {inviteService} from './invite.service';
import {companyService} from "./companyService";
import {countriesService} from "./countries.service";

export const shared = angular.module('shared', [])
	.constant('API', api)
	.constant('ROLE',ROLE)
	.constant('REST',REST)
	.factory('__env', __env)
	.factory('helperService', helperService)
	.factory('userService', userService)
	.factory('companyService', companyService)
	.factory('Posts', posts)
	.factory('eventListenerService', eventListenerService)
	.factory('messageService', messageService)
	.factory('AuthenticationService', AuthenticationService)
	.factory('menu', menu)
	.factory('countriesService', countriesService)
	.factory('inviteService', inviteService);


