	'use strict';

	const userService = ($q, $http, REST, __env, ROLE, helperService) => {
		let user = {};

		const setUser = (data) => {
			user = data;
			localStorage.setItem('user', JSON.stringify(data));
		}

		const getUserFromStorage = () => {
			var storageUser = JSON.parse(localStorage.getItem('user'));
			if (!_.isUndefined(storageUser) && _.size(storageUser) > 0) {
				setUser(storageUser);
				return user;
			}

			deleteUserAndToken();
			return false;
		}

		const getUser = () => {
			var promise = $q.when();
			if (_.size(user) === 0) {
				if(getUserFromStorage()){
					promise = $q.when(getUserFromStorage());
				}
			} else {
				promise = $q.when(user);
			}

			return promise;
		}


		const getUserFromBackend = (id) => {
			var promise = $q.when();
			var service = __env.getEnvironment().apiUrl + REST.user;
			$http({
				method: "get",
				url: service + '/' + id
			}).then(function (data) {
				setUser(data.data);
				promise = $q.when(data.data);

			}, function (error) {
				user = {};
				deleteUserAndToken();
				promise = $q.when(false);
			});

			return promise;
		}


		const editUser = (userdata) => {
			var promise = $q.when();
			var service = __env.getEnvironment().apiUrl + REST.user;
			$http({
				method: "put",
				url: service + '/' + userdata.id,
				data: userdata
			}).then(function (data) {
				setUser(data.data);
				promise = $q.when(data.data);
			}, function (error) {
				user = {};
				deleteUserAndToken();
				promise = $q.when(false);
			});

			return promise;
		}

		const editUserInline = (userdata) => {
			var promise = $q.defer();
			var service = __env.getEnvironment().apiUrl + REST.user_edit_inline;
			$http({
				method: "put",
				url: service + '/' + userdata.id,
				data: userdata
			}).then(function (data) {
				setUser(data.data);
				promise.resolve(data.data);
			}, function (error) {
				user = {};
				deleteUserAndToken();
				promise.reject(false);
			});

			return promise.promise;
		}

		const deleteUserAndToken = () => {
			localStorage.removeItem('user');
			localStorage.removeItem('token');
		}

		const checkRole = (page, usr) => {
			var promise = $q.when();
			var response = {};

			if(!(usr instanceof Object)){
				response.access = false;
				response.message = "Please log in";
				response.route = "login";
				promise = $q.when(response);
			} else if (!ROLE[page]) {
				response.access = false;
				response.message = "Page is not defined in ROLE config. Please tell admin to correct this!";
				response.route = "login";
				promise = $q.when(response);
			} else if (usr && !usr.roles) {
				response.access = false;
				response.message = "Logged in user does not seem to have any role data defined. That is why you are redirected";
				response.route = "home";
				promise = $q.when(response);
			} else if (!helperService.arrayIntersect(ROLE[page], usr.roles)) {
				response.access = false;
				response.message = "You don't have a permission to access '/" + page + "' url";
				promise = $q.when(response);
			} else {
				response.access = true;
				response.message = "";
				promise = $q.when(response);
			}
			return promise;
		}

		const checkUserAndRole = (page) => {
			return $q.all([
				getUser()
			]).then(function (data) {
				return checkRole(page,data[0])
			});

		}

		return { editUser,editUserInline, getUserFromBackend, setUser,getUser, checkUserAndRole};
	}

	userService.$inject = ['$q', '$http', 'REST', '__env', 'ROLE', 'helperService'];

	export {userService};
