import angular from 'angular';
import uiRouter from 'angular-ui-router';
import {companyComponent} from "./../../components/company/company.component";
import {companyDetails} from "./../../components/company-details/company.details.component";

export const company = angular.module('company', [uiRouter])
	.component('companyComponent', companyComponent)
	.component('companyDetails', companyDetails)
	.config(($stateProvider) => {
		$stateProvider
			.state('company', {
			url      : '/company',
			component: 'companyComponent',
			resolve  : {
				loggedUser: function () {
					if (!localStorage.getItem('user')) {
						return false;
					}
					try {
						let user = JSON.parse(localStorage.getItem('user'));
						if (!_.isUndefined(user.roles)) return true;
					} catch (e) {
						return false;
					}

					return false;
				}
			}
		})
			.state('company-details', {
				url      : '/company-details/:id',
				component: 'companyDetails',
				resolve  : {
					loggedUser: function () {
						if (!localStorage.getItem('user')) {
							return false;
						}
						try {
							let user = JSON.parse(localStorage.getItem('user'));
							if (!_.isUndefined(user.roles)) return true;
						} catch (e) {
							return false;
						}

						return false;
					}
				}
			})
	});
