import angular from 'angular';
import uiRouter from 'angular-ui-router';
import {ContactController} from './contact.controller';
import template from './contact.html';

export const contact = angular.module('contact', [uiRouter])
	.config(($stateProvider) => {
		$stateProvider.state('contact', {
			url         : '/contact',
			controller  : ContactController,
			controllerAs: 'vm',
			template    : template,
			resolve     : {
				loggedUser: function () {
					if(!localStorage.getItem('user')){
						return false;
					}
					try {
						let user = JSON.parse(localStorage.getItem('user'));
						if(!_.isUndefined(user.roles)) return true;
					} catch (e) {
						return false;
					}

					return false;
				}
			}
		})
	})
