'use strict';

class LoginController {

	constructor($state, AuthenticationService, loggedUser, $rootScope) {
		this.$state                = $state;
		this.AuthenticationService = AuthenticationService;
		this.email                 = '';
		this.password              = '';
		this.loggedIn              = loggedUser;
		console.log(this.loggedIn);
		this.$rootScope            = $rootScope;
		this.registerListeners();
	}

	login = () => {
		this.AuthenticationService.Login(this.email, this.password).then((result) => {
			this.loggedIn = result;
			if (this.loggedIn === true) {
				this.$state.go('home', {}, {reload: true});
			}
		});
	}

	logout = () => {
		this.AuthenticationService.Logout();
		this.loggedIn = false;
		this.$state.go('login', {location: true});
	}

	updateStateTrue = () => {
		this.loggedIn = true;
	}

	updateStateFalse = () => {
		this.loggedIn = false;
	}

	registerListeners = () => {
		this.$rootScope.$on('event:auth-logout-succeed', this.updateStateFalse);
		this.$rootScope.$on('event:auth-login-complete', this.updateStateTrue);
	}


}

LoginController.$inject = ['$state', 'AuthenticationService', 'loggedUser', '$rootScope'];

export {LoginController}
