import angular from 'angular';
import uiRouter from 'angular-ui-router';
import {LoginController} from './login.controller';
import template from './login.html';

export const login = angular.module('login', [uiRouter])
	.config(($stateProvider) => {
		$stateProvider.state('login', {
			url         : '/login',
			controller  : LoginController,
			controllerAs: 'vm',
			template    : template,
			resolve     : {
				loggedUser: function () {
					if(!localStorage.getItem('user')){
						return false;
					}
					try {
						let user = JSON.parse(localStorage.getItem('user'));
						if(!_.isUndefined(user.roles)) return true;
					} catch (e) {
						return false;
					}

					return false;
				}
			}
		})
	})
