'use strict';
class ContactDetailsCtrl {

	constructor(helperService, $state, $stateParams, contactService) {
		this.helperService = helperService;
		this.$state = $state;
		this.$stateParams = $stateParams;
		this.contactService = contactService;
		this.init();
	}

	init() {
		this.contact = this.helperService.getTransferredObject(this.$stateParams.id)
		if (_.size(this.contact) == 0) {
			this.contactService.getContact(this.$stateParams.id).then(data => {
				this.contact = data;
			});
		}
	}
}
ContactDetailsCtrl.$inject = ['helperService', '$state', '$stateParams', 'contactService'];

export {ContactDetailsCtrl};
