const contactService   = ($q, $http, REST, __env, $httpParamSerializer, $cacheFactory) => {
	var cache = $cacheFactory(contactService);

	const getUserContacts = (data) => {
		let promise  = $q.defer();
		let cacheKey = JSON.stringify(data);
		let url      = __env.getEnvironment().apiUrl + REST.contacts + '?' + $httpParamSerializer(data)

		let contactData = cache.get(cacheKey);
		if (contactData) {
			promise.resolve(contactData);
			return promise.promise;
		}

		$http({
			method: "get",
			url   : url
		}).then(function (data) {
			cache.put(cacheKey, data.data);
			promise.resolve(data.data);
		}, function (error) {
			promise.reject(false);
		});

		return promise.promise;
	}

	const getContact = (id) => {
		let promise  = $q.defer();
		let cacheKey = id;
		let url      = __env.getEnvironment().apiUrl + REST.contacts + '/' + id

		let contactData = cache.get(cacheKey);
		if (contactData) {
			promise.resolve(contactData);
			return promise.promise;
		}

		$http({
			method: "get",
			url   : url
		}).then(function (data) {
			cache.put(cacheKey, data.data);
			promise.resolve(data.data);
		}, function (error) {
			promise.reject(false);
		});

		return promise.promise;
	}

	return {getUserContacts, getContact};
}

contactService.$inject = ['$q', '$http', 'REST', '__env', '$httpParamSerializer', '$cacheFactory'];

export {contactService};
