'use strict';
class UserContactsCtrl {

	constructor(contactService, helperService, $state) {
		this.contactService = contactService;
		this.helperService = helperService;
		this.$state = $state;
		this.contacts         = [];
		this.limit            = 5;
		this.offset           = 0;
		this.lazyLoadFinished = false;
		this.fetchContacts();
	}

	fetchContacts() {
		let user = JSON.parse(localStorage.getItem('user'));
		var data = {
			"citeration": {"company": {"id": user.company.id}},
			"order"     : {
				"id": "asc"
			},
			"limit"     : this.limit,
			"offset"    : this.offset
		};

		this.contactService.getUserContacts(data, user.id).then(serverdata => {
			if (_.size(serverdata) === 0) {
				this.lazyLoadFinished = true;
				return;
			}
			_.each(serverdata, (item, key) => {
				if (item.id !== user.id) {
					this.contacts.push(item);
				}
			});

			this.offset = this.limit;
			this.limit  = this.limit + 5;
		});
	};

	viewDetails(contact) {
		this.helperService.setTransferredObject(contact.id, contact);
		this.$state.go('contact-details', {id: contact.id});
	}

}

UserContactsCtrl.$inject = ['contactService', 'helperService', '$state'];

export {UserContactsCtrl};
