'use strict';

class UserCtrl {

	constructor($scope, toastr, userService, $stateParams, $state, messageService) {
		this.$scope = $scope;
		this.$scope.user = {};
		this.userRef = this.$scope.user;
		this.toastr = toastr;
		this.userService = userService;
		this.$stateParams = $stateParams;
		this.$state = $state;
		this.messageService = messageService;
		this.triggeredUpdate = false;
		this.initialize();
	}


	initialize() {
		this.userService.getUser().then((data) => {
			this.checkLocalUserData(data);
		});
	}


	checkLocalUserData(userData) {
		if (userData === false) {
			this.redirectToLogin("User data not found, please log in");
			return;
		}

		this.$scope.user = userData;
		this.watchIt();
	}


	redirectToLogin(message) {
		this.messageService.errorMsg(message);
		this.$state.go('login', {location: true});

	}


	userServiceResponse = (data) => {
		if (data === false) {
			this.messageService.errorMsg("User is not edited");
			this.triggeredUpdate = false;
			return false;
		}

		this.messageService.successMsg("User is edited");
		this.userService.setUser(data);
		this.triggeredUpdate = false;
	}

	whatToWatch = () => {
		return this.$scope.user;
	}

	watcher = (newData, oldData) => {
		if (!_.isMatch(newData, oldData)) {
			if (!this.triggeredUpdate) {
				this.triggeredUpdate = true;
				this.userService.editUserInline(newData).then(this.userServiceResponse);
			}
		}
	}

	watchIt() {
		this.$scope.$watchCollection(this.whatToWatch,this.watcher);
	}
}

UserCtrl.$inject = ['$scope','toastr', 'userService', '$stateParams', '$state', 'messageService'];

export {UserCtrl};
