'use strict';
import uiRouter from 'angular-ui-router';
import {contactService} from './services/contact.service';
import {UserCtrl} from './user.controller';
import {UserContactsCtrl} from './user.contacts.controller';
import {ContactDetailsCtrl} from './contact.details.controller';

import angular from 'angular';

const user = angular.module('user', [uiRouter])
	.config(($stateProvider) => {

		$stateProvider
			.state('user', {
				url          : '/user',
				templateUrl  : 'app/views/user/views/user.html',
				controller   : UserCtrl,
				controllerAs : 'vm',
				ncyBreadcrumb: {
					label: 'User'
				},
				resolve      : {
					security: ($state, userService, messageService) => {
						return (
							userService.checkUserAndRole("user").then(function (data) {
								if (data.access === false) {
									messageService.errorMsg(data.message);
									var route = (data.route) ? data.route : "login";
									$state.go(route, {location: true});
								}
							})
						);
					}
				}
			})
			.state('user-contacts', {
				url          : '/user/contacts',
				templateUrl  : 'app/views/user/views/user-contacts.html',
				controller   : UserContactsCtrl,
				controllerAs : 'vm',
				ncyBreadcrumb: {
					label: 'User > Contacts'
				},
				resolve      : {
					security: ($state, userService, messageService) => {
						return (
							userService.checkUserAndRole("user").then(function (data) {
								if (data.access === false) {
									messageService.errorMsg(data.message);
									var route = (data.route) ? data.route : "login";
									$state.go(route, {location: true});
								}
							})
						);
					}
				}
			})
			.state('contact-details', {
				url          : '/user/contacts/:id',
				templateUrl  : 'app/views/user/views/contact-details.html',
				controller   : ContactDetailsCtrl,
				controllerAs : 'vm',
				ncyBreadcrumb: {
					label: 'User > Contacts > Details'
				},
				resolve      : {
					security: ($state, userService, messageService) => {
						return (
							userService.checkUserAndRole("user").then(function (data) {
								if (data.access === false) {
									messageService.errorMsg(data.message);
									var route = (data.route) ? data.route : "login";
									$state.go(route, {location: true});
								}
							})
						);
					}
				}
			});
	})
	.factory('contactService', contactService);

user.$inject = ['$stateProvider', 'userService', 'messageService'];

export default {user};
