'use strict';
var gulp  = require('gulp');
var $     = require('gulp-load-plugins')();
var babel = require('gulp-babel');
// Check for --production flag

var development = $.environments.development;
var production  = $.environments.production;

var paths = {
	assets    : [
		'./app/assets/*.js'
	],
// These files are for your app's JavaScript
	appJS     : [
		'app/app.js',
		'app/services/*.js',
		'app/services/**/*.js',
		'app/services/**/**/*.js',
		'global-services/*.js',
		'global-services/**/*.js',
		'global-services/**/**/*.js',
		'app/components/*.js',
		'app/components/**/*.js',
		'app/components/**/**/*.js',
		'app/views/*.js',
		'app/views/**/*.js',
		'app/views/**/**/*.js',
		'app/directives/*.js',
		'app/directives/**/*.js',
		'app/directives/**/**/*.js'

	], jsOrder: [
		'**/app.js',
		'**/*.module.js',
		'**/*.route.js',
		'**/*.service.js',
		'app/**.js'
	]
};


gulp.task('build:app', function () {
	var uglify = $.if(production(), $.uglify()
		.on('error', function (e) {
			console.log(e);
		}));

	return gulp.src(paths.appJS)
		.pipe($.order(paths.jsOrder))
/*		.pipe(babel({
			presets: ['es2015']
		}))*/
	//	.pipe(uglify)
		.pipe($.concat('app.js'))
		.pipe(gulp.dest('./build/assets/js/'));
});
