'use strict';
var gulp  = require('gulp');
var $     = require('gulp-load-plugins')();
var babel = require('gulp-babel');
var rename = require("gulp-rename");
// Check for --production flag

var development = $.environments.development;
var production  = $.environments.production;

var paths = {
	assets    : [
		'./app/assets/*.es6'
	],
// These files are for your app's JavaScript
	appJS     : [
		'app/app.es6',
		'app/services/*.es6',
		'app/services/**/*.es6',
		'app/services/**/**/*.es6',
		'global-services/*.es6',
		'global-services/**/*.es6',
		'global-services/**/**/*.es6',
		'app/components/*.es6',
		'app/components/**/*.es6',
		'app/components/**/**/*.es6',
		'app/views/*.es6',
		'app/views/**/*.es6',
		'app/views/**/**/*.es6',
		'app/directives/*.es6',
		'app/directives/**/*.es6',
		'app/directives/**/**/*.es6',
		'app/*.es6',

	], jsOrder: [
		'**/app.es6',
		'**/*.module.es6',
		'**/*.route.es6',
		'**/*.service.es6',
		'**/*.es6'
	]
};


gulp.task('build:transpile', function () {
	var uglify = $.if(production(), $.uglify()
		.on('error', function (e) {
			console.log(e);
		}));

	return gulp.src(paths.appJS)
		.pipe(babel({
			presets: ['es2015']
		}))
		.pipe(rename({
			extname: ".js"
		}))
		.pipe(gulp.dest(function(file) {
			return file.base;
		}));

});



