var gulp    = require('gulp');
var sync    = require('run-sequence');
var webpack = require('webpack-stream');
var todo    = require('gulp-todoist');
var path    = require('path');
var yargs   = require('yargs').argv;
var tpl     = require('gulp-template');
var rename  = require('gulp-rename');

/*
 map of paths for using with the tasks below
 */
var paths = {
	entry: 'app/app.js',
	app: ['client/app/**/*.{js,styl,html}', 'client/styles/**/*.styl'],
	js: 'app/**/**.js',
	toCopy: ['index.html'],
	html: ['index.html', '**/*.html'],
	dest: 'build',
	blankTemplates: 'templates/component/*.**'
};

// helper funciton
var resolveToComponents = function(glob){
	glob = glob || '';
	return path.join('app', 'app/components', glob); // app/components/{glob}
};

gulp.task('todo', function() {
	return gulp.src(paths.js)
		.pipe(todo({silent: false, verbose: true}));
});

gulp.task('build', ['todo'], function() {
	return gulp.src(paths.entry)
		.pipe(webpack(require('webpack.config.js')))
		.pipe(gulp.dest(paths.dest));
});

gulp.task('serve', function() {
	browser({
		port: process.env.PORT || 4500,
		open: false,
		ghostMode: false,
		server: {
			baseDir: 'dist'
		}
	});
});

/*
 simple task to copy over needed files to dist
 */
gulp.task('copy', function() {
	return gulp.src(paths.toCopy, { base: 'client' })
		.pipe(gulp.dest(paths.dest));
});

/*
 task to watch files for changes and call build and copy tasks
 */
gulp.task('watch', function() {
	gulp.watch(paths.app, ['build', browser.reload]);
	gulp.watch(paths.toCopy, ['copy', browser.reload]);
});

gulp.task('component', function(){
	var cap = function(val){
		return val.charAt(0).toUpperCase() + val.slice(1);
	};

	var name = yargs.name;
	var parentPath = yargs.parent || '';
	var destPath = path.join(resolveToComponents(), parentPath, name);

	return gulp.src(paths.blankTemplates)
		.pipe(tpl({
			name: name,
			upCaseName: cap(name)
		}))
		.pipe(rename(function(path){
			path.basename = path.basename.replace('component', name);
		}))
		.pipe(gulp.dest(destPath));
});


gulp.task('default', function(done) {
	sync('build', 'copy', 'watch', done)
});
