var gulp 			= require('gulp');
var $ 				= require('gulp-load-plugins')();

var cssmin = require('gulp-cssmin');

var development = $.environments.development;
var production 	= $.environments.production;

var paths = {

	assets: [
		'lib/bootstrap/dist/css/bootstrap.css',
		'lib/html5-boilerplate/dist/css/normalize.css',
		'lib/html5-boilerplate/dist/css/main.css',
		'lib/angular-loading-bar/build/loading-bar.css',
		'lib/bootstrap-sweetalert/dist/sweet-alert.css',
		'lib/angular-ui-tree/dist/angular-ui-tree.css',
		'lib/ng-img-crop/compile/unminified/ng-img-crop.css',
		'lib/angular-material/angular-material.css',
		'app/assets/css/*.css',
		'app/assets/css/**/*.css'
	]

};


gulp.task('css:min-css', function() {

	var minify = $.if(production(), cssmin()
		.on('error', function (e) {
			console.log(e);
		}));


	return gulp.src(paths.assets)

		.pipe(minify)
		.pipe($.concat('all.css'))
		.pipe(gulp.dest('./build/assets/css/'));

});
