'use strict';
var gulp    = require('gulp');
var sync    = require('run-sequence');
var browser = require('browser-sync');
var webpack = require('webpack-stream');
var todo    = require('gulp-todoist');
var path    = require('path');
var yargs   = require('yargs').argv;
var tpl     = require('gulp-template');
var rename  = require('gulp-rename');

/*
 map of paths for using with the tasks below
 */
var paths = {
	entry: 'app/app.js',
	app: ['app/**/*.{js,styl,html}','app/**/**/*.{js,styl,html}','app/**/**/**/*.{js,styl,html}', 'styles/**/*.styl'],
	js: ['app/**/**.js','app/**.js','app/**/**/**.js','app/**/**/**/**.js'],
	styl: ['app/**/*.styl', 'style/**/*.styl','assets/css/**.css'],
	toCopy: ['index.html'],
	html: ['index.html', 'app/**/*.html','app/**/**/*.html','app/**/**/**/*.html'],
	dest: 'build'
};

// helper function
var resolveToComponents = function(glob){
	glob = glob || '';
	return path.join('', 'app/components', glob); // app/components/{glob}
};

gulp.task('todo', function() {
	return gulp.src(paths.js)
		.pipe(todo({silent: false, verbose: true}));
});

gulp.task('build', ['todo'], function() {
	return gulp.src(paths.entry)
		.pipe(webpack(require('./webpack.config')))
		.pipe(gulp.dest(paths.dest));
});

gulp.task('serve', function() {
	browser({
		port: process.env.PORT || 4500,
		open: true,
		ghostMode: false,
		server: {
			baseDir: './'
		},
		fallback: './index.html'
	});
});

/*
 simple task to copy over needed files to dist
 */
gulp.task('copy', function() {
	return gulp.src(paths.toCopy, { base: 'app' })
		.pipe(gulp.dest(paths.dest));
});

/*
 task to watch files for changes and call build and copy tasks
 */
gulp.task('watch', function() {
	gulp.watch(paths.app, ['build', browser.reload]);
	gulp.watch(paths.toCopy, ['copy', browser.reload]);
});

gulp.task('component', function(){
	var cap = function(val){
		return val.charAt(0).toUpperCase() + val.slice(1);
	};

	var name = yargs.name;
	var parentPath = yargs.parent || '';
	var destPath = path.join(resolveToComponents(), parentPath, name);

	return gulp.src(paths.blankTemplates)
		.pipe(tpl({
			name: name,
			upCaseName: cap(name)
		}))
		.pipe(rename(function(path){
			path.basename = path.basename.replace('component', name);
		}))
		.pipe(gulp.dest(destPath));
});


gulp.task('default', function(done) {
	sync('build', 'copy','serve', 'watch', done)
});
