/*
 config for webpack. Will be used in
 the Gulpfile for building our app.
 Does not need gulp in order to do so,
 but we use gulp to orchestrate
 */
var path = require("path");
var webpack = require("webpack");
var DEBUG = true;
module.exports = {
	output: {
		filename: 'bundle.js'
	},

	devtool: DEBUG ? 'source-map' : false,

	module: {
		loaders: [
			{ test: /\.html$/, loader: 'raw' },
			{ test: /\.styl$/, loader: 'style!css!stylus' },
			{ test: /\.css$/, loader: "style-loader!css-loader" },
			{ test: /\.(png|jpg|jpeg)$/, loader: 'file' },
			{ test: /\.js$/, loader: 'babel?stage=1', exclude: [/node_modules/] }
		]
	},
	resolve: {
		modulesDirectories: ["node_modules"]
	},

	stylus: {
		use: [require('jeet')(), require('rupture')()]
	}
};

