import { stateChanges } from './state-changes';
import { waitForLoaded } from './loaded';
import 'rxjs/add/operator/skipWhile';
import 'rxjs/add/operator/withLatestFrom';
import 'rxjs/add/operator/map';
export function createAuditTrail(query) {
    return (events) => auditTrail(query, events);
}
export function auditTrail(query, events) {
    const auditTrail$ = stateChanges(query, events)
        .scan((current, action) => [...current, action], []);
    return waitForLoaded(query, auditTrail$);
}
//# sourceMappingURL=audit-trail.js.map