import { createLoadedChanges, loadedSnapshotChanges } from './loaded';
import { createStateChanges } from './state-changes';
import { createAuditTrail } from './audit-trail';
import { createDataOperationMethod } from './data-operation';
import { createRemoveMethod } from './remove';
export function createListReference(query) {
    return {
        query: query,
        update: createDataOperationMethod(query.ref, 'update'),
        set: createDataOperationMethod(query.ref, 'set'),
        push: function (data) { return query.ref.push(data); },
        remove: createRemoveMethod(query.ref),
        snapshotChanges: createLoadedChanges(query),
        stateChanges: createStateChanges(query),
        auditTrail: createAuditTrail(query),
        valueChanges: function (events) {
            return loadedSnapshotChanges(query, events)
                .map(function (actions) { return actions.map(function (a) { return a.payload.val(); }); });
        }
    };
}
//# sourceMappingURL=create-reference.js.map