"use strict";
// The MIT License (MIT)
//
// Copyright (c) 2017 Firebase
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const _ = require("lodash");
const WILDCARD_REGEX = new RegExp('{[^/{}]*}', 'g');
function _makeParams(event, triggerResource) {
    if (!event.resource) {
        return event.params || {};
    }
    let wildcards = triggerResource.match(WILDCARD_REGEX);
    let params = {};
    if (wildcards) {
        let triggerResourceParts = _.split(triggerResource, '/');
        let eventResourceParts = _.split(event.resource, '/');
        _.forEach(wildcards, wildcard => {
            let wildcardNoBraces = wildcard.slice(1, -1);
            let position = _.indexOf(triggerResourceParts, wildcard);
            params[wildcardNoBraces] = eventResourceParts[position];
        });
    }
    return params;
}
/** @internal */
function makeCloudFunction({ provider, eventType, resource, dataConstructor = (raw) => raw.data, handler, before = () => { return; }, after = () => { return; }, }) {
    let cloudFunction = (event) => __awaiter(this, void 0, void 0, function* () {
        try {
            before(event);
            let typedEvent = _.cloneDeep(event);
            typedEvent.data = dataConstructor(event);
            typedEvent.params = _makeParams(event, resource) || {};
            let promise = handler(typedEvent);
            if (typeof promise === 'undefined') {
                console.warn('Function returned undefined, expected Promise or value');
            }
            return yield promise;
        }
        finally {
            after(event);
        }
    });
    cloudFunction.__trigger = {
        eventTrigger: {
            resource,
            eventType: `providers/${provider}/eventTypes/${eventType}`,
        },
    };
    return cloudFunction;
}
exports.makeCloudFunction = makeCloudFunction;
