import { fromRef } from '../observable/fromRef';
import { snapshotChanges } from './snapshot-changes';
import 'rxjs/add/operator/skipWhile';
import 'rxjs/add/operator/withLatestFrom';
import 'rxjs/add/operator/map';
export function createLoadedChanges(query) {
    return (events) => loadedSnapshotChanges(query, events);
}
export function loadedData(query) {
    return fromRef(query, 'value')
        .map(data => {
        let lastKeyToLoad;
        data.payload.forEach(child => {
            lastKeyToLoad = child.key;
            return false;
        });
        return { data, lastKeyToLoad };
    });
}
export function waitForLoaded(query, action$) {
    const loaded$ = loadedData(query);
    return loaded$
        .withLatestFrom(action$)
        .map(([loaded, actions]) => {
        let lastKeyToLoad = loaded.lastKeyToLoad;
        const loadedKeys = actions.map(snap => snap.key);
        return { actions, lastKeyToLoad, loadedKeys };
    })
        .skipWhile(meta => meta.loadedKeys.indexOf(meta.lastKeyToLoad) === -1)
        .map(meta => meta.actions);
}
export function loadedSnapshotChanges(query, events) {
    const snapChanges$ = snapshotChanges(query, events);
    return waitForLoaded(query, snapChanges$);
}
//# sourceMappingURL=loaded.js.map