import { Observable } from 'rxjs/Observable';
import { observeOn } from 'rxjs/operator/observeOn';
import { ZoneScheduler } from 'angularfire2';
import 'rxjs/add/operator/map';
import 'rxjs/add/operator/delay';
export function fromRef(ref, event, listenType = 'on') {
    const ref$ = new Observable(subscriber => {
        const fn = ref[listenType](event, (snapshot, prevKey) => {
            subscriber.next({ snapshot, prevKey });
        }, subscriber.error.bind(subscriber));
        return { unsubscribe() { ref.off(event, fn); } };
    })
        .map((payload) => {
        const { snapshot, prevKey } = payload;
        let key = null;
        if (snapshot) {
            key = snapshot.key;
        }
        return { type: event, payload: snapshot, prevKey, key };
    })
        .delay(0);
    return observeOn.call(ref$, new ZoneScheduler(Zone.current));
}
//# sourceMappingURL=fromRef.js.map