import { fromRef } from '../observable/fromRef';
import { Observable } from 'rxjs/Observable';
import { positionFor, positionAfter } from './utils';
import 'rxjs/add/operator/scan';
import 'rxjs/add/observable/merge';
export function listChanges(ref, events) {
    var childEvent$ = events.map(function (event) { return fromRef(ref, event); });
    return Observable.merge.apply(Observable, childEvent$).scan(function (current, action) {
        var payload = action.payload, type = action.type, prevKey = action.prevKey, key = action.key;
        switch (action.type) {
            case 'child_added':
                return current.concat([action]);
            case 'child_removed':
                return current.filter(function (x) { return x.payload.key !== payload.key; });
            case 'child_changed':
                return current.map(function (x) { return x.payload.key === key ? action : x; });
            case 'child_moved':
                var curPos = positionFor(current, payload.key);
                if (curPos > -1) {
                    var data = current.splice(curPos, 1)[0];
                    var newPost = positionAfter(current, prevKey);
                    current.splice(newPost, 0, data);
                    return current;
                }
                return current;
            default:
                return current;
        }
    }, []);
}
//# sourceMappingURL=changes.js.map