import { CloudFunction, Event } from '../cloud-functions';
import * as firebase from 'firebase-admin';
/** Handle events in the Firebase Auth user lifecycle. */
export declare function user(): UserBuilder;
export declare class UserRecordMetadata implements firebase.auth.UserMetadata {
    creationTime: string;
    lastSignInTime: string;
    constructor(creationTime: string, lastSignInTime: string);
    toJSON(): {
        creationTime: string;
        lastSignInTime: string;
    };
}
/** Builder used to create Cloud Functions for Firebase Auth user lifecycle events. */
export declare class UserBuilder {
    private resource;
    private static dataConstructor(raw);
    /** Respond to the creation of a Firebase Auth user. */
    onCreate(handler: (event: Event<UserRecord>) => PromiseLike<any> | any): CloudFunction<UserRecord>;
    /** Respond to the deletion of a Firebase Auth user. */
    onDelete(handler: (event: Event<UserRecord>) => PromiseLike<any> | any): CloudFunction<UserRecord>;
}
/**
 * The UserRecord passed to Cloud Functions is the same UserRecord that is returned by the Firebase Admin
 * SDK.
 */
export declare type UserRecord = firebase.auth.UserRecord;
