"use strict";
// The MIT License (MIT)
//
// Copyright (c) 2017 Firebase
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
Object.defineProperty(exports, "__esModule", { value: true });
const cloud_functions_1 = require("../cloud-functions");
const index_1 = require("../index");
/** @internal */
exports.provider = 'cloud.storage';
/**
 * The optional bucket function allows you to choose which buckets' events to handle.
 * This step can be bypassed by calling object() directly, which will use the bucket that
 * the Firebase SDK for Cloud Storage uses.
 */
function bucket(bucket) {
    if (!/^[a-z\d][a-z\d\\._-]{1,230}[a-z\d]$/.test(bucket)) {
        throw new Error('Invalid bucket name ${bucket}');
    }
    return new BucketBuilder(`projects/_/buckets/${bucket}`);
}
exports.bucket = bucket;
function object() {
    return bucket(index_1.config().firebase.storageBucket).object();
}
exports.object = object;
class BucketBuilder {
    /** @internal */
    constructor(resource) {
        this.resource = resource;
    }
    /** Handle events for objects in this bucket. */
    object() {
        return new ObjectBuilder(this.resource);
    }
}
exports.BucketBuilder = BucketBuilder;
class ObjectBuilder {
    /** @internal */
    constructor(resource) {
        this.resource = resource;
    }
    /**
     * Handle any change to any object.
     */
    onChange(handler) {
        return cloud_functions_1.makeCloudFunction({ provider: exports.provider, handler: handler, resource: this.resource, eventType: 'object.change' });
    }
}
exports.ObjectBuilder = ObjectBuilder;
