/*
 * Copyright 2017, Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * Note: this file is purely for documentation. Any contents are not expected
 * to be loaded as the JS file.
 */

/**
 * Wrapper message for `double`.
 *
 * The JSON representation for `DoubleValue` is JSON number.
 *
 * @property {number} value
 *   The double value.
 *
 * @typedef DoubleValue
 * @memberof google.protobuf
 * @see [google.protobuf.DoubleValue definition in proto format]{@link https://github.com/google/protobuf/blob/master/src/google/protobuf/wrappers.proto}
 */
var DoubleValue = {
  // This is for documentation. Actual contents will be loaded by gRPC.
};

/**
 * Wrapper message for `float`.
 *
 * The JSON representation for `FloatValue` is JSON number.
 *
 * @property {number} value
 *   The float value.
 *
 * @typedef FloatValue
 * @memberof google.protobuf
 * @see [google.protobuf.FloatValue definition in proto format]{@link https://github.com/google/protobuf/blob/master/src/google/protobuf/wrappers.proto}
 */
var FloatValue = {
  // This is for documentation. Actual contents will be loaded by gRPC.
};

/**
 * Wrapper message for `int64`.
 *
 * The JSON representation for `Int64Value` is JSON string.
 *
 * @property {number} value
 *   The int64 value.
 *
 * @typedef Int64Value
 * @memberof google.protobuf
 * @see [google.protobuf.Int64Value definition in proto format]{@link https://github.com/google/protobuf/blob/master/src/google/protobuf/wrappers.proto}
 */
var Int64Value = {
  // This is for documentation. Actual contents will be loaded by gRPC.
};

/**
 * Wrapper message for `uint64`.
 *
 * The JSON representation for `UInt64Value` is JSON string.
 *
 * @property {number} value
 *   The uint64 value.
 *
 * @typedef UInt64Value
 * @memberof google.protobuf
 * @see [google.protobuf.UInt64Value definition in proto format]{@link https://github.com/google/protobuf/blob/master/src/google/protobuf/wrappers.proto}
 */
var UInt64Value = {
  // This is for documentation. Actual contents will be loaded by gRPC.
};

/**
 * Wrapper message for `int32`.
 *
 * The JSON representation for `Int32Value` is JSON number.
 *
 * @property {number} value
 *   The int32 value.
 *
 * @typedef Int32Value
 * @memberof google.protobuf
 * @see [google.protobuf.Int32Value definition in proto format]{@link https://github.com/google/protobuf/blob/master/src/google/protobuf/wrappers.proto}
 */
var Int32Value = {
  // This is for documentation. Actual contents will be loaded by gRPC.
};

/**
 * Wrapper message for `uint32`.
 *
 * The JSON representation for `UInt32Value` is JSON number.
 *
 * @property {number} value
 *   The uint32 value.
 *
 * @typedef UInt32Value
 * @memberof google.protobuf
 * @see [google.protobuf.UInt32Value definition in proto format]{@link https://github.com/google/protobuf/blob/master/src/google/protobuf/wrappers.proto}
 */
var UInt32Value = {
  // This is for documentation. Actual contents will be loaded by gRPC.
};

/**
 * Wrapper message for `bool`.
 *
 * The JSON representation for `BoolValue` is JSON `true` and `false`.
 *
 * @property {boolean} value
 *   The bool value.
 *
 * @typedef BoolValue
 * @memberof google.protobuf
 * @see [google.protobuf.BoolValue definition in proto format]{@link https://github.com/google/protobuf/blob/master/src/google/protobuf/wrappers.proto}
 */
var BoolValue = {
  // This is for documentation. Actual contents will be loaded by gRPC.
};

/**
 * Wrapper message for `string`.
 *
 * The JSON representation for `StringValue` is JSON string.
 *
 * @property {string} value
 *   The string value.
 *
 * @typedef StringValue
 * @memberof google.protobuf
 * @see [google.protobuf.StringValue definition in proto format]{@link https://github.com/google/protobuf/blob/master/src/google/protobuf/wrappers.proto}
 */
var StringValue = {
  // This is for documentation. Actual contents will be loaded by gRPC.
};

/**
 * Wrapper message for `bytes`.
 *
 * The JSON representation for `BytesValue` is JSON string.
 *
 * @property {string} value
 *   The bytes value.
 *
 * @typedef BytesValue
 * @memberof google.protobuf
 * @see [google.protobuf.BytesValue definition in proto format]{@link https://github.com/google/protobuf/blob/master/src/google/protobuf/wrappers.proto}
 */
var BytesValue = {
  // This is for documentation. Actual contents will be loaded by gRPC.
};