import { stateChanges } from './state-changes';
import { waitForLoaded } from './loaded';
import 'rxjs/add/operator/skipWhile';
import 'rxjs/add/operator/withLatestFrom';
import 'rxjs/add/operator/map';
export function createAuditTrail(query) {
    return function (events) { return auditTrail(query, events); };
}
export function auditTrail(query, events) {
    var auditTrail$ = stateChanges(query, events)
        .scan(function (current, action) { return current.concat([action]); }, []);
    return waitForLoaded(query, auditTrail$);
}
//# sourceMappingURL=audit-trail.js.map